#region Copyright Syncfusion Inc. 2001 - 2024
//
//  Copyright Syncfusion Inc. 2001 - 2024. All rights reserved.
//
//  Use of this code is subject to the terms of our license.
//  A copy of the current license can be obtained at any time by e-mailing
//  licensing@syncfusion.com. Re-distribution in any form is strictly
//  prohibited. Any infringement will be prosecuted under applicable laws. 
//
#endregion

using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Syncfusion.Pdf;
using Syncfusion.Windows.Forms;
using Syncfusion.Pdf.Parsing;
using Syncfusion.Licensing;

namespace EssentialPDFSamples
{
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : MetroForm
    {
        private System.Windows.Forms.Button btnMerge;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.PictureBox pictureBox1;
        private TextBox txtDoc1;
        private TextBox txtDoc2;
        private Button btnBrowse1;
        private Button btnBrowse2;
        private Label label2;
        private Label label3;
        private Label label4;
        private Label label5;
        private CheckBox optimizeResources;
        private CheckBox MergeAccessibilityTags;

        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();
            this.MinimizeBox = true;
            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            ComponentResourceManager resources = new ComponentResourceManager(typeof(Form1));
            btnMerge = new System.Windows.Forms.Button();
            label1 = new System.Windows.Forms.Label();
            pictureBox1 = new System.Windows.Forms.PictureBox();
            txtDoc1 = new System.Windows.Forms.TextBox();
            txtDoc2 = new System.Windows.Forms.TextBox();
            btnBrowse1 = new System.Windows.Forms.Button();
            btnBrowse2 = new System.Windows.Forms.Button();
            label2 = new System.Windows.Forms.Label();
            label3 = new System.Windows.Forms.Label();
            label4 = new System.Windows.Forms.Label();
            label5 = new System.Windows.Forms.Label();
            optimizeResources = new System.Windows.Forms.CheckBox();
            MergeAccessibilityTags = new CheckBox();
            ((ISupportInitialize)pictureBox1).BeginInit();
            SuspendLayout();
            // 
            // btnMerge
            // 
            btnMerge.Anchor = AnchorStyles.Top | AnchorStyles.Right;
            btnMerge.BackColor = Color.Transparent;
            btnMerge.FlatAppearance.BorderColor = Color.FromArgb(255, 192, 128);
            btnMerge.FlatAppearance.MouseDownBackColor = Color.FromArgb(255, 224, 192);
            btnMerge.FlatAppearance.MouseOverBackColor = Color.FromArgb(255, 255, 192);
            btnMerge.ImageAlign = ContentAlignment.MiddleRight;
            btnMerge.Location = new Point(467, 452);
            btnMerge.Margin = new Padding(5, 6, 5, 6);
            btnMerge.Name = "btnMerge";
            btnMerge.Size = new Size(133, 44);
            btnMerge.TabIndex = 0;
            btnMerge.Text = "Merge PDF";
            btnMerge.UseVisualStyleBackColor = false;
            btnMerge.Click += btnMerge_Click;
            // 
            // label1
            // 
            label1.Font = new Font("Arial", 8.25F, FontStyle.Regular, GraphicsUnit.Point, 0);
            label1.ForeColor = Color.FromArgb(0, 0, 64);
            label1.Location = new Point(0, 173);
            label1.Margin = new Padding(5, 0, 5, 0);
            label1.Name = "label1";
            label1.Size = new Size(622, 77);
            label1.TabIndex = 1;
            label1.Text = "Click the button to view an PDF document generated by Essential PDF.  Please note that Adobe Reader or its equivalent is required to view the resultant document.";
            // 
            // pictureBox1
            // 
            pictureBox1.Dock = DockStyle.Top;
			pictureBox1.Image = System.Drawing.Image.FromFile(GetFullTemplatePath("pdf_header.png", true));
            pictureBox1.Location = new Point(0, 0);
            pictureBox1.Margin = new Padding(5, 6, 5, 6);
            pictureBox1.Name = "pictureBox1";
            pictureBox1.Size = new Size(627, 163);
            pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
            pictureBox1.TabIndex = 24;
            pictureBox1.TabStop = false;
            // 
            // txtDoc1
            // 
            txtDoc1.Location = new Point(255, 319);
            txtDoc1.Margin = new Padding(5, 6, 5, 6);
            txtDoc1.Name = "txtDoc1";
            txtDoc1.Size = new Size(217, 31);
            txtDoc1.TabIndex = 25;
            // 
            // txtDoc2
            // 
            txtDoc2.Location = new Point(255, 383);
            txtDoc2.Margin = new Padding(5, 6, 5, 6);
            txtDoc2.Name = "txtDoc2";
            txtDoc2.Size = new Size(217, 31);
            txtDoc2.TabIndex = 26;
            // 
            // btnBrowse1
            // 
            btnBrowse1.FlatStyle = FlatStyle.System;
            btnBrowse1.Location = new Point(485, 317);
            btnBrowse1.Margin = new Padding(5, 6, 5, 6);
            btnBrowse1.Name = "btnBrowse1";
            btnBrowse1.Size = new Size(95, 44);
            btnBrowse1.TabIndex = 27;
            btnBrowse1.Text = "Browse";
            btnBrowse1.UseVisualStyleBackColor = true;
            btnBrowse1.Click += btnBrowse1_Click;
            // 
            // btnBrowse2
            // 
            btnBrowse2.FlatStyle = FlatStyle.System;
            btnBrowse2.Location = new Point(485, 381);
            btnBrowse2.Margin = new Padding(5, 6, 5, 6);
            btnBrowse2.Name = "btnBrowse2";
            btnBrowse2.Size = new Size(95, 44);
            btnBrowse2.TabIndex = 28;
            btnBrowse2.Text = "Browse";
            btnBrowse2.UseVisualStyleBackColor = true;
            btnBrowse2.Click += btnBrowse2_Click;
            // 
            // label2
            // 
            label2.AutoSize = true;
            label2.Location = new Point(18, 325);
            label2.Margin = new Padding(5, 0, 5, 0);
            label2.Name = "label2";
            label2.Size = new Size(158, 25);
            label2.TabIndex = 29;
            label2.Text = "Select a document";
            // 
            // label3
            // 
            label3.AutoSize = true;
            label3.Location = new Point(18, 383);
            label3.Margin = new Padding(5, 0, 5, 0);
            label3.Name = "label3";
            label3.Size = new Size(210, 25);
            label3.TabIndex = 30;
            label3.Text = "Select another document";
            // 
            // label4
            // 
            label4.BackColor = Color.FromArgb(143, 164, 190);
            label4.Location = new Point(38, 302);
            label4.Margin = new Padding(5, 0, 5, 0);
            label4.Name = "label4";
            label4.Size = new Size(542, 2);
            label4.TabIndex = 31;
            // 
            // label5
            // 
            label5.Font = new Font("Arial", 8.25F, FontStyle.Bold, GraphicsUnit.Point, 0);
            label5.ForeColor = Color.MidnightBlue;
            label5.Image = (Image)resources.GetObject("label5.Image");
            label5.ImageAlign = ContentAlignment.MiddleLeft;
            label5.Location = new Point(35, 260);
            label5.Margin = new Padding(5, 0, 5, 0);
            label5.Name = "label5";
            label5.Size = new Size(302, 42);
            label5.TabIndex = 32;
            label5.Text = "Select Documents to Merge";
            label5.TextAlign = ContentAlignment.MiddleRight;
            // 
            // optimizeResources
            // 
            optimizeResources.AutoSize = true;
            optimizeResources.Checked = true;
            optimizeResources.CheckState = CheckState.Checked;
            optimizeResources.FlatStyle = FlatStyle.System;
            optimizeResources.Location = new Point(18, 426);
            optimizeResources.Margin = new Padding(5, 6, 5, 6);
            optimizeResources.Name = "optimizeResources";
            optimizeResources.Size = new Size(243, 30);
            optimizeResources.TabIndex = 33;
            optimizeResources.Text = "Optimize PDF Resources";
            optimizeResources.UseVisualStyleBackColor = true;
          
            // 
            // MergeAccessibilityTags
            // 
            MergeAccessibilityTags.AutoSize = true;
            MergeAccessibilityTags.Checked = true;
            MergeAccessibilityTags.CheckState = CheckState.Checked;
            MergeAccessibilityTags.FlatStyle = FlatStyle.System;
            MergeAccessibilityTags.Location = new Point(18, 466);
            MergeAccessibilityTags.Margin = new Padding(5, 6, 5, 6);
            MergeAccessibilityTags.Name = "MergeAccessibilityTags";
            MergeAccessibilityTags.Size = new Size(243, 30);
            MergeAccessibilityTags.TabIndex = 34;
            MergeAccessibilityTags.Text = "Merge Accessibility Tags";
            MergeAccessibilityTags.UseVisualStyleBackColor = true;
        
            // 
            // Form1
            // 
            AutoScaleDimensions = new SizeF(10F, 25F);
            AutoScaleMode = AutoScaleMode.Font;
            BackColor = Color.White;
            ClientSize = new Size(627, 530);
            Controls.Add(MergeAccessibilityTags);
            Controls.Add(btnBrowse2);
            Controls.Add(label3);
            Controls.Add(txtDoc2);
            Controls.Add(label2);
            Controls.Add(btnBrowse1);
            Controls.Add(txtDoc1);
            Controls.Add(label5);
            Controls.Add(label4);
            Controls.Add(optimizeResources);
            Controls.Add(btnMerge);
            Controls.Add(pictureBox1);
            Controls.Add(label1);
            FormBorderStyle = FormBorderStyle.FixedSingle;
            Margin = new Padding(5, 6, 5, 6);
            MaximizeBox = false;
            MinimizeBox = false;
            Name = "Form1";
            StartPosition = FormStartPosition.CenterScreen;
            Text = "Merge Document";
            Load += Form1_Load;
            ((ISupportInitialize)pictureBox1).EndInit();
            ResumeLayout(false);
            PerformLayout();
        }
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
			SyncfusionLicenseProvider.RegisterLicense(DemoCommon.FindLicenseKey());
			Application.EnableVisualStyles();
            Application.Run(new Form1());
        }

        private void btnMerge_Click(object sender, System.EventArgs e)
        {

            string[] paths = {txtDoc1.Tag.ToString() , txtDoc2.Tag.ToString() };

            PdfDocument doc;

            if (this.optimizeResources.Checked || this.MergeAccessibilityTags.Checked)
            {
                PdfMergeOptions mergeOption = new PdfMergeOptions
                {
                    MergeAccessibilityTags = this.MergeAccessibilityTags.Checked ? true : false,
                    OptimizeResources = this.optimizeResources.Checked ? true : false
                };
                doc = PdfDocument.Merge(paths, mergeOption);
            }
            else
            {
                doc = PdfDocument.Merge(paths);
            }
            
            doc.Save("Sample.pdf");

            //Message box confirmation to view the created PDF document.
            if (MessageBox.Show("Do you want to view the PDF file?", "PDF File Created",
                MessageBoxButtons.YesNo, MessageBoxIcon.Information)
                == DialogResult.Yes)
            {
                //Launching the PDF file using the default Application.[Acrobat Reader]
#if NETCORE
                System.Diagnostics.Process process = new System.Diagnostics.Process();
                process.StartInfo = new System.Diagnostics.ProcessStartInfo("Sample.pdf")
                {
                    UseShellExecute = true
                };
                process.Start();
#else
                System.Diagnostics.Process.Start("Sample.pdf");
#endif
                this.Close();
            }
            else
            {
                // Exit
                this.Close();
            }
        }

        private void btnBrowse1_Click(object sender, EventArgs e)
        {
            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "PDF Documents (*.pdf)|*.PDF";

            if (file.ShowDialog() == DialogResult.OK)
            {
                txtDoc1.Text = file.SafeFileName;
                txtDoc1.Tag = file.FileName;
            }
        }

        private void btnBrowse2_Click(object sender, EventArgs e)
        {
            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "PDF Documents (*.pdf)|*.PDF";

            if (file.ShowDialog() == DialogResult.OK)
            {
                txtDoc2.Text = file.SafeFileName;
                txtDoc2.Tag = file.FileName;
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
#if NETCORE
            txtDoc1.Tag = @"..\..\..\..\..\..\..\Common\Data\PDF\HTTP Succinctly.pdf";
#else
            txtDoc1.Tag = @"..\..\..\..\..\..\Common\Data\PDF\HTTP Succinctly.pdf";
#endif
            txtDoc1.Text = @"HTTP Succinctly.pdf";
#if NETCORE
            txtDoc2.Tag = @"..\..\..\..\..\..\..\Common\Data\PDF\HTTP Succinctly.pdf";
#else
            txtDoc2.Tag = @"..\..\..\..\..\..\Common\Data\PDF\HTTP Succinctly.pdf";
#endif
            txtDoc2.Text = @"HTTP Succinctly.pdf";
        }
		 /// <summary>
        /// Gets the full path of the PDF template or image.
        /// </summary>
        /// <param name="fileName">Name of the file</param>
        /// <param name="image">True if image</param>
        /// <returns>Path of the file</returns>
        private string GetFullTemplatePath(string fileName, bool image)
        {
#if NETCORE
            string fullPath = @"..\..\..\..\..\..\..\Common\";
#else
            string fullPath = @"..\..\..\..\..\..\Common\";
#endif
            string folder = image ? "Images" : "Data";

            return string.Format(@"{0}{1}\PDF\{2}", fullPath, folder, fileName);
        }

    }
	/// <summary>
    /// Represents a class that is used to find the licensing file for Syncfusion controls.
    /// </summary>
    public class DemoCommon
    {

        /// <summary>
        /// Finds the license key from the Common folder.
        /// </summary>
        /// <returns>Returns the license key.</returns>
        public static string FindLicenseKey()
        {

            string licenseKeyFile = @"Common\\SyncfusionLicense.txt";

            for (int n = 0; n < 20; n++)
            {
                if (!System.IO.File.Exists(licenseKeyFile))
                {
                    licenseKeyFile = @"..\" + licenseKeyFile;
                    continue;
                }
                return System.IO.File.ReadAllText(licenseKeyFile);
            }
            return string.Empty;
        }
    }
}
